app.controller('ProfileController', function($scope,$rootScope,$interval,$http,$location,Restangular,Notification,SessionProvider){	
	$scope.tabs=['profile','cmd','mobile'];
	$scope.selectedTab = $location.search()['tab'];	
	let ctrl = this;
	ctrl.deviceEnrollTimer=null;
	ctrl.SessionProvider = SessionProvider;
	ctrl.mobileqr = '';
	if (typeof $scope.selectedTab === 'undefined'){
		$scope.activeTab=0;		
	
	}else {
		$scope.activeTab=$scope.tabs.indexOf($scope.selectedTab);		
	}

	
	$scope.selectTab = function(tab){
    	$scope.selectedTab = tab;
		$location.search("tab",tab);
    };
	$scope.getProfile=function(){
		ctrl.profile={};
		$http.get("/api/account/profile").then(function(response){
			ctrl.profile = response.data;			
		},function(response){
			Notification.error("Unable to get favorites");
		});

	};
    $scope.changePassword = function(){
		if (ctrl.newPassword!=ctrl.newPassword2)
			alert('Confirm new password again');
		else{
			let data={password:ctrl.newPassword,oldpassword:ctrl.oldPassword};
			$http.post('/api/account/updatepassword',data).then(function(response){
				Notification.success('Password updated');
				ctrl.oldPassword="";
				ctrl.newPassword="";
				ctrl.newPassword2="";
				
			},function(response){
				ctrl.oldPassword="";
				ctrl.newPassword="";
				ctrl.newPassword2="";
				Notification.error('Unable to update password: '+response.data.error);				
				console.log(response);
			});
			
			
		}
	};
	$scope.enrollMobile = function(){
		ctrl.mobileqr = '';
		$http.get("/api/account/mobile/enrollMobileDevice").then(function(response){
			let data = response.data;
			ctrl.mobileqr = data.mobileqr;
			$scope.runDeviceEnrollTimer();
		}, function(response){
			Notification.error('Unable to enroll mobile device: '+response.data.error);				
		})
	};
	$scope.deleteMobile=function(){
		//let data={value:""};
		if (confirm("Do you want to delete this device?")){    	
			let data={};
			$http.post('/api/account/profile/MOBILE/del',data).then(function(response){
				delete ctrl.profile.MOBILE;
				Notification.success('Mobile device deleted');
			},function(response){
				Notification.error('Unable to delete device');				
				console.log(response);
			});
		}

	};
	$scope.runDeviceEnrollTimer=function(){
		ctrl.deviceEnrollCheckInterval = 2000;
        ctrl.deviceEnrollTimer=$interval(function(){            
        if (ctrl.deviceEnrollCheckInterval >0 ){            
            $http.get("/api/account/mobile/device").then(function(response){
                let data = response.data;
                if (data.status==="enrolled"){
                	ctrl.mobileqr=""
                    $interval.cancel(ctrl.deviceEnrollTimer);
                    ctrl.deviceEnrollCheckInterval=0;
                    $scope.getProfile();
                    
                }/*else if (data.status==="fail"){
                    Notification.error("Unable to login with push method, mobile device not properly enrolled");
                    $interval.cancel(ctrl.deviceEnrollTimer);
                    ctrl.deviceEnrollCheckInterval=0;                    
                }*/
            },function(response){
                    Notification.error("Unable to get enrollment status");
                    $interval.cancel(ctrl.deviceEnrollTimer);
                    ctrl.deviceEnrollCheckInterval=0;
                    
            });
        }
        },ctrl.deviceEnrollCheckInterval);
	};

	$scope.getProfile();
    /*$scope.buildNewElement = function(){
		let result = {};
		result["config"]={};			
		return result;
	};*/
	$scope.$on("$destroy",function(){        
		if (ctrl.deviceEnrollTimer!=null)
        	$interval.cancel(ctrl.deviceEnrollTimer);
    });    
});		
