angular.
module('authService', [
  'ngStorage'
  ]).
factory('AuthService', function($rootScope,$http,$interval,$location,Restangular,Notification,SessionProvider) {
    var self = this;
    this.protectionTimer=null;
    this.protectorInterval = 1000;    
    this.windowHeight=0;
    this.windowWidth=0;
    this.isProtectorEnabled = true;

    this.init = function() {      
      //if (SessionProvider.token!=""){
        self.checkToken();        
      //}
    };
    this.checkToken=function(){      
        $http.defaults.headers.common[SessionProvider.headerName] = SessionProvider.token;
        $http.get("/api/account/checkaccess").
            then(function(response) {                
                let data = response.data;                             
                SessionProvider.setUser(data);                
                SessionProvider.setAuthorized(true);                                
                //$http.defaults.headers.common[SessionProvider.headerName] = SessionProvider.token;
                $location.path($location.path());               
                self.runProtector(1000);
            }, function(response) {
                SessionProvider.setAuthorized(false);                
                //SessionProvider.updateToken("");
                
                //$http.defaults.headers.common[SessionProvider.headerName] = SessionProvider.token;
            });
    };
    this.doLogin=function(data){        
        
        //console.log(data);
        $http.post('/api/account/auth',data).
            then(function(response) {   
                let data = response.data;             
                //SessionProvider.updateToken(response.data.token);                
                SessionProvider.setUser(data);                
                SessionProvider.setAuthorized(true);                
                //$http.defaults.headers.common[SessionProvider.headerName] = SessionProvider.token;                
                $rootScope.$broadcast('onAuthOK',{});                                        
                self.runProtector(1000);
                //$location.path('/laps');                
                $location.path('/secrets');                

            }, function(response) {
                SessionProvider.setAuthorized(false);                
                let data = response.data;
                let result={};
                if (data!=null && data.hasOwnProperty("capcha_img")){
                    result.capcha_img= data.capcha_img;
                }
                if (data!=null && data.hasOwnProperty("capcha_uuid")){
                    result.capcha_uuid= data.capcha_uuid;
                }
                result.status= data.status;
                if (response.status==403){
                    switch(data.status){
                        case "GENERATE_OTP":                        
                        case "PASSWORD_CHANGE":
                            result.token = data.token;
                            //$rootScope.$broadcast('onAuthStatus',{status:data.status,token:data.token});                        
                            $rootScope.$broadcast('onAuthStatus',result);                        
                            if (data.hasOwnProperty('error')){
                                Notification.error(data.error);    
                            }
                            break;
                        case "CAPCHA_REQUIRED":
                        case "WRONG_CAPCHA":
                            //$rootScope.$broadcast('onAuthStatus',{status:data.status});                        
                            $rootScope.$broadcast('onAuthStatus',result);                        
                            Notification.error("Login failed: "+data.status);
                            /*if (data.hasOwnProperty('reason')){
                                Notification.error("Login failed: "+data.reason);    
                            }*/
                            break;
                        /*case "WRONG_CAPCHA":
                            $rootScope.$broadcast('onAuthStatus',{status:data.status});                        
                            Notification.error("Login failed: "+data.status);
                            break;*/
                        case "LOCKOUT_TIMEOUT":
                            Notification.error(data.error);
                            $rootScope.$broadcast('onAuthStatus',{status:data.status,token:""});                        
                            break;
                        default:
                            Notification.error("Login failed: "+data.status);
                            $rootScope.$broadcast('onAuthStatus',{status:data.status,token:""});                        
                            SessionProvider.setAuthorized(false);                
                            break;

                    }
                }else if(response.status == 500){
                    Notification.error(data.message);
                    $rootScope.$broadcast('onAuthStatus',{status:"500",token:""});                        
                }
                else if(response.status == 429){
                    Notification.error("Too many requests");
                    $rootScope.$broadcast('onAuthStatus',{status:"too many errors",token:""});                        
                }else{
                    $rootScope.$broadcast('onAuthStatus',{status:"Unknown error",token:""});                        
                    SessionProvider.setAuthorized(false);                
                }
                    
                
                
                
                //self.token="";
                //SessionProvider.updateToken("");
                //$http.defaults.headers.common[SessionProvider.headerName] = SessionProvider.token;
                
            });
    };
    this.doPushLogin = function(login,timeout){
        let payload={login:login};
        $http.post('/api/account/pushauth',payload).
            then(function(response) {                   
                let data = response.data;             
                self.pushSession = data.session;                                
                self.runPushWaiter(login,data.session,timeout);                
                Notification.success("Please confirm authentication using mobile app");
            }, function(response) {
                let data = response.data;
                SessionProvider.setAuthorized(false);                
                Notification.error("Unable to login via push: "+data.error);    
                $rootScope.$broadcast('onAuthStatus',{status:"500",token:""});                        
            });      
    };
    this.logout = function(){
        $http.get("/api/account/logout").then(function(response){
            SessionProvider.setAuthorized(false);                
            //SessionProvider.updateToken("");            
            //$http.defaults.headers.common[self.headerName] = self.token;
            $location.search('');
            $location.path('/login');
            
        },function(response){
            console.log(response);
        });
        clearCookies();
        self.stopProtector();
    };
    this.runPushWaiter=function(login,session,timeout){        
        if (self.pushTimer!=null){
            $interval.cancel(self.pushTimer);    
        }        
        self.pushWaiterStarted = Math.floor(Date.now() / 1000);
        self.pushWaiterInterval = 1000;
        self.pushTimer=$interval(function(){                
            let ts = Math.floor(Date.now() / 1000);
            if (ts-self.pushWaiterStarted>timeout){
                Notification.error("Push authentication confirmation timeout reached, no reply from mobile device recieved");
                $interval.cancel(self.pushTimer);
                self.pushWaiterInterval=0;
                SessionProvider.setAuthorized(false);
                $rootScope.$broadcast('onAuthStatus',{status:"push_timeout_reached"});                            
            }else if (self.pushWaiterInterval >0 ){
                let payload={"session":session, "login":login};
                $http.post("/api/account/pushstatus",payload).then(function(response){
                    let data = response.data;
                    if (data.status==="true"){
                        $interval.cancel(self.pushTimer);
                        self.pushWaiterInterval=0;
                        SessionProvider.setUser(data);                
                        SessionProvider.setAuthorized(true);                
                        $rootScope.$broadcast('onAuthOK',{});               
                        self.runProtector(1000);                                             
                        //$location.path('/laps');   
                        $location.path('/secrets');                             
                    }else if (data.status==="false"){
                        Notification.error("Authentication rejected from mobile device");
                        $interval.cancel(self.pushTimer);
                        self.pushWaiterInterval=0;
                        SessionProvider.setAuthorized(false);
                        $rootScope.$broadcast('onAuthStatus',{status:data.status});                            
                    }
                    else if (data.status==="fail"){
                        Notification.error("Unable to login with push method, mobile device not properly enrolled");
                        $interval.cancel(self.pushTimer);
                        self.pushWaiterInterval=0;
                        SessionProvider.setAuthorized(false);
                        $rootScope.$broadcast('onAuthStatus',{status:data.status});        
                        
                    }
                },function(response){
                        Notification.error("Unable to check push authentication result");
                        $interval.cancel(self.pushTimer);
                        self.pushWaiterInterval=0;
                        SessionProvider.setAuthorized(false);                
                });
            }
            //console.log("protector tik");
        },self.pushWaiterInterval);

    };
    this.runProtector=function(){        
        self.windowHeight = window.innerHeight;
        self.windowWidth = window.innerWidth;
        self.colorDepth = screen.colorDepth;
        self.protectorInterval = 1000;
        self.protectionTimer=$interval(function(){
            //console.log("timer");        
            if (self.protectorInterval >0 && this.innerWidth>0 && this.innerHeight>0 && self.isProtectorEnabled){
                if (window.innerWidth!=self.windowWidth || window.innerHeight!=self.windowHeight || self.colorDepth != screen.colorDepth){
                    console.log('Width or height changed, do logout');
                    Notification.error("Window size changed, do logout!");
                    self.logout();
                }                
            }
            // if (self.protectorInterval >0){
            //     let curdateTime = Math.floor( new Date()/1000);                
            // }
            //console.log("protector tik");
        },self.protectorInterval);

    };
    this.setProtectorActive=function(isEnabled){
        self.isProtectorEnabled = isEnabled;
        if (isEnabled===false){
            self.stopProtector();            
        }
    }
    this.stopProtector=function(){
        $interval.cancel(self.protectionTimer);
        self.protectorInterval=0;
    };
    $rootScope.$on("$destroy",function(){
        $interval.cancel(self.protectionTimer);
        $interval.cancel(self.pushTimer);
    });    
    self.init();
    return self;
   
});








