angular.
module('FilterService', ['ngSanitize']).
factory('filterService', function($rootScope,$location,$sanitize,$window,Restangular) {

	var resolution=100;
	var dateFormat="dd.MM.yyyy";
	var isAutoInt=true;
	// Save a reference to this
	var self = this;
	this.filter={};
	var uid=1;
	
	
	this.init = function() {
	    self.filter.name = "New filter";
		self.filter.id = null;
		self.filter.from={};
		self.filter.to={};		
		self.filter.from.datetime=0;
		self.filter.from.date = new Date("2015-08-01");
		self.filter.from.h = 0;
		self.filter.from.m = 0;
		self.filter.from.s = 0;

		self.filter.from.datetime=0;
		self.filter.to.date = new Date("2016-08-01");
		self.filter.to.h = 0;
		self.filter.to.m = 0;
		self.filter.to.s = 0;

		self.filter.autoDrill=true;
		self.filter.indexPattern="fx-*";
		self.filter.sql=null;
		self.filter.queries=[];
		self.filter.sorts=[];

		self.filter.loadLimit = 100;
		
		self.fields_list=[];
		self.filter.selectedFieldsList=[];
		
		self.filter.interval=0;
		
/*		self.fields_list.push('src_ip');
		self.fields_list.push('login');
		self.fields_list.push('passport');
		self.fields_list.push('ack');
		self.fields_list.push('ip_dst13');
		self.fields_list.push('ip_dst14');
*/		//self.filter.selectedFieldsList.push('src_ip');
		self.fieldsCaption={};
		self.timezone='browser';

		self.allFields = Restangular.all('fields').getList();
		self.search_field_list=[];
		//self.loadFieldList();


	};
	this.getFieldList=function() {		
		return self.fields_list;
	};
	//get field list for filter block. depending on caller return arrays
	this.loadFieldList = function(source){
		self.search_field_list=[];			
		self.fields_list=[];		
		self.fieldsCaption={};
		self.fieldsTypes={};
		self.allFields.then(function(response) { 
			var allFields = response.plain();
			angular.forEach(allFields, function(f){					
				switch (source){
					case "grouped":
						if (f.aggregatable){
							self.fields_list.push(f.field);
						}
						break;
					default:
						self.fields_list.push(f.field);
						break;
				}
				if (f.hasOwnProperty('caption'))
					self.fieldsCaption[f.field]=f.caption;
				else
					self.fieldsCaption[f.field]=f.field;
				if (f.searchable)
					self.search_field_list.push(f.field);

				self.fieldsTypes[f.field] = f.type;
			});			
		});				
		
		return self.fields_list;;
	};
	this.getFieldType = function(field){
		let result = "";
		result = self.fieldsTypes[field];
		return result;
	}
	/* used in query editor*/
	this.getFieldsForQuery = function(){
		var fields=[];
		//self.allFields.then()
		angular.forEach(self.search_field_list, function(f){					
			//if (f.searchable)
				fields.push(f);				
		});	

		fields.push("AND ");				
		fields.push("OR ");				
		fields.push("NOT ");				
		return fields;
	};
	this.getFieldCaption = function(field){
		if (self.fieldsCaption.hasOwnProperty(field))
			return self.fieldsCaption[field];
		else 
			return field;

	};
	this.clearFilter=function(){
		self.filter.queries=[];
		uid=1;	
	};
	this.addQuery = function(operator,field,value){
		let s_query="";
		let s_value = value;
		s_value = s_value.replace(/(["\\])/g,'\\$1');
		//s_value = s_value.replace(/([":+-=!(){}[]\^\\\~\*\?\/])/g,'\\$1');
		switch (self.getFieldType(field)){
			//'keyword','text','integer','long','double','ip','mac','date','boolean'
			case "keyword": 
			case "text":
			case "mac":
			case "date":
				s_value='"'+s_value+'"';
				break;			
		}
		
		//s_value='"'+s_value+'"';

		
		switch (operator){
			case "=":
				s_query = field+":"+s_value;
				break;
			case "!=":
				s_query = "NOT "+field+":"+s_value;
				break;
			case "contains":
				break;
		}
				
		var found=false;				
		for(i in self.filter.queries) {
			if( self.filter.queries[i].text.trim() === s_query) {
				found=true;
				break;
			}
		}
		if (found===false){
			query={};
			query.enabled=true;
			query.valid=true;
			query.text=s_query;
			query.id=uid++;
			self.filter.queries.push(query);						
		}
		if (self.filter.autoDrill && s_value!="")
			$rootScope.$broadcast('searchGlobal');
		
	};
	this.addRawQuery = function(value,silently){	
		var found=false;		
		var s_value = value.toString().trim();
		for(i in self.filter.queries) {
			if( self.filter.queries[i].text.trim() === s_value) {
				found=true;
				break;
			}
		}
		if (found===false){
			query={};
			query.enabled=true;
			query.valid=true;
			query.text=s_value;
			query.id=uid++;
			self.filter.queries.push(query);						
		}
		if (self.filter.autoDrill && s_value!="" && silently!==true)
			$rootScope.$broadcast('searchGlobal');
					
	};
	
		
	this.removeQuery = function(id){
		for(i in self.filter.queries) {
			if( self.filter.queries[i].id == id) {
				self.filter.queries.splice(i,1);							
			}
		}
		if (self.filter.autoDrill)
			$rootScope.$broadcast('searchGlobal');
	};	
	this.toggleQuery = function(id){
		for(i in self.filter.queries) {
			if( self.filter.queries[i].id == id) {
				self.filter.queries[i].enabled=!self.filter.queries[i].enabled;							
			}
		}
		if (self.filter.autoDrill)
			$rootScope.$broadcast('searchGlobal');
	};
	this.editQuery = function(id,value){
		var s_value = value.toString().trim();
		for(i in self.filter.queries) {
			if( self.filter.queries[i].id == id) {
				self.filter.queries[i].text=s_value;							
			}
		}
		if (self.filter.autoDrill)
			$rootScope.$broadcast('searchGlobal');
	};
	this.setQueries=function(queries){
		self.filter.queries = queries;
	};
	this.getFilter=function(){
		return self.filter;
		//return {};
	};

	this.toggle_field=function(field){
		var i = self.filter.selectedFieldsList.indexOf(field);
		let status=false;
		if (i>-1){
			//contains
			self.filter.selectedFieldsList.splice(i,1);
			status=false;
		}else{
			self.filter.selectedFieldsList.push(field);
			status=true;
		}
		$rootScope.$broadcast('fieldsChanged',{field:field,status:status});

	};
	this.setSorts=function(sorts){
		self.filter.sorts=sorts;
		if (self.filter.autoDrill)
			$rootScope.$broadcast('searchGlobal');	
	};
	this.isAutoDrill= function(){
		return self.filter.autoDrill;
	};
	
	this.getSelectedFields=function(){
		return self.filter.selectedFieldsList;
	};

	//from and to are in UTC
	this.setDate=function(from,to){
		self.filter.from.datetime = from;				
		self.filter.to.datetime = to;

		/*self.filter.from.datetime = flx.convertToUTC(from);				
		self.filter.to.datetime = flx.convertToUTC(to);*/

		var dFrom = new Date(self.filter.from.datetime);
		var dTo = new Date(self.filter.to.datetime);

		self.filter.from.date = new Date(dFrom.getFullYear(), dFrom.getMonth(), dFrom.getDate(), 0, 0, 0);

		self.filter.from.h = dFrom.getHours();
		self.filter.from.m = dFrom.getMinutes();
		self.filter.from.s = dFrom.getSeconds();
		
		self.filter.to.date = new Date(dTo.getFullYear(), dTo.getMonth(), dTo.getDate(), 0, 0, 0);
		self.filter.to.h = dTo.getHours();
		self.filter.to.m = dTo.getMinutes();
		self.filter.to.s = dTo.getSeconds();
		
	};
	this.getInterval = function(){
		if (isAutoInt==true)
			return flx.calc_interval(self.filter.from.datetime,self.filter.to.datetime,resolution);
		else{
			return 0;
		}
	};
	this.getTimeZone=function function_name() {
		return self.timezone;
	};
	//desiarilize location hash
	this.restoreFromObject = function function_name(model) {		
		if (model.hasOwnProperty('from')&& model.hasOwnProperty('to')){
			var dFrom = flx.convertToUTC((new Date(model.from)).getTime());
			var dTo = flx.convertToUTC((new Date(model.to)).getTime());				
			//this.setDate((new Date(model.from)).getTime(),(new Date(model.to).getTime()));
			this.setDate(moment(model.from).valueOf(),moment(model.to).valueOf());
		}else{
			let to = moment();
			let from = moment().subtract(15,'minutes');							   
			this.setDate(from.valueOf(),to.valueOf());
		}
		if (model.hasOwnProperty('queries')){
			this.clearFilter()
			angular.forEach(model.queries, function(value){									
				//self.addRawQuery($sanitize(value),true);
				self.addRawQuery(value,true);
			});
		}
		if (model.hasOwnProperty('fields')){
			self.filter.selectedFieldsList=[];
			angular.forEach(model.fields, function(value){		
				console.log(value);
				//self.addQuery($sanitize(value));
				self.filter.selectedFieldsList.push(value);

			});
			$rootScope.$broadcast('fieldsChanged');
		}
		if (model.hasOwnProperty('autoDrill'))
			self.filter.autoDrill = model.autoDrill;
		else
			self.filter.autoDrill = false;

		if (model.hasOwnProperty('indexPattern'))
			self.filter.indexPattern = model.indexPattern;
		else
			self.filter.indexPattern = "fx-*";
		if (model.hasOwnProperty('autoLoad'))
			self.filter.autoLoad = model.autoLoad;
		else
			self.filter.autoLoad = false;
		if (model.hasOwnProperty('loadLimit'))
			self.filter.loadLimit = model.loadLimit;
		else
			self.filter.loadLimit = 100;
	}
	this.parseLocation = function function_name() {
		let hash = Object.keys($location.search())[0];
		/*var hash="";
		if (search.hasOwnProperty('filter'))
			hash = search.filter;*/
		try{
			let model = JSON.parse(hash);
			if (model!=null){
				self.restoreFromObject(model)
			}
			
		}
		catch(e){
			//no filter in search string
			self.filter.selectedFieldsList=[];
			self.clearFilter();
			let to = moment();
			let from = moment().subtract(15,'minutes');							   
			this.setDate(from.valueOf(),to.valueOf());			

/*			if (self.filter.queries.length==0)
				self.addQuery("*");
*/			//load default fields
			//
			//console.log(e);
			console.log(hash);
		}
		
	};
	/*
	@isAutoLoad - autoload data on page open according to filter

	*/
	this.buldJsonLocation = function(isAutoLoad,includeFields){
		var temp = {};
		temp.from = new Date(self.filter.from.datetime);
		temp.to = new Date(self.filter.to.datetime);
		temp.autoDrill = self.filter.autoDrill;
		temp.indexPattern = self.filter.indexPattern;		
		temp.queries=[];
		temp.loadLimit = parseInt(self.filter.loadLimit);
		angular.forEach(self.filter.queries, function(value){					
			if (value.enabled)
				temp.queries.push(value.text);
		});
		if (includeFields){
			temp.fields=[];
			angular.forEach(self.filter.selectedFieldsList, function(value){
				temp.fields.push(value);
			});
		}
		if (isAutoLoad)
			temp.autoLoad = true;
		return JSON.stringify(temp);
	};
	//serialize params to location hash (url)
	this.toLocation = function (isAutoLoad,includeFields) {		
		$location.search(this.buldJsonLocation(isAutoLoad,includeFields));
	};
	
	
	self.init();
	return self;
});