angular.
module('QueryService', []).
factory('queryService', function($q,$http) {
  var self = this;  
  this.init = function() {
    self.queue=[];
  };
  
  this.execNext = function() {
    let task = self.queue[0];
    $http(task.c).then(function(data) {
      self.removeTaskForField(task.field);
      
      //oself.queue.shift();
      task.d.resolve(data);
      if (self.queue.length>0) 
          self.execNext();
    }, function(err) {
      self.removeTaskForField(task.field);
      //self.queue.shift();
      task.d.reject(err);      
      if (self.queue.length>0) 
        self.execNext();
    })
    ;
  }; 
  self.removeTaskForField=function(field){
    let index = _.findIndex(self.queue, { 'field': field});
      if (index>=0){
        self.queue.splice(index,1);
      }
  };
  self.enqueue =  function(config) {    
    var d = $q.defer();
    self.queue.push({c:config,d:d, field:config.field});
    console.log(config.field);
    if (self.queue.length===1) 
      self.execNext();            
    return d.promise;
  };
  self.cancelAll=function(withError){
    angular.forEach(self.queue, function(task, key) {      
      if (withError){
        let err={};
        err.data={};            
        err.data.error = "Cancelled";
        task.d.reject(err);      
      }else
        task.d.resolve({});
      console.log("Task for "+task.c.field+" cancelled");
    });
    self.queue=[];
  };
  self.cancelField=function(field){
    let index = _.findIndex(self.queue, { 'field': field});
    if (index>=0){
      let task = self.queue[index];
      let err={};
      err.data={};            
      err.data.error = "Cancelled";
      task.d.reject(err);      
      self.queue.splice(index,1);
    }
  };
  self.init();
  return self;
  
  
  
});


