function FlxFactory(){
	flx={};
	flx.calc_interval=function(from,to,size) {
		var interval=flx.round_interval((to-from)/size);		
		return interval;
	}
	flx.convertToUTC=function(mills){
		var date = moment(mills).clone().toDate();
		var res = (new Date(date.getTime()+date.getTimezoneOffset() * 60000)).getTime(); 
		return res;
	}
	flx.UTCtoLocal=function(mills){
		var date = moment(mills).clone().toDate();
		var res = (new Date(date.getTime()-date.getTimezoneOffset() * 60000)).getTime();
		return res;
	}
	flx.utcToLocalString = function(mills){
		var date = moment(mills).format("dddd, MMMM Do YYYY, h:mm:ss a");
		return date;
	}
	flx.round_interval = function(interval) {
		
		switch (true) {
			// 0.5s
			case (interval <= 500):
			  return 100;       // 0.1s
			// 5s
			case (interval <= 5000):
			  return 1000;      // 1s
			// 7.5s
			case (interval <= 7500):
			  return 5000;      // 5s
			// 15s
			case (interval <= 15000):
			  return 10000;     // 10s
			// 45s
			case (interval <= 45000):
			  return 30000;     // 30s
			// 3m
			case (interval <= 180000):
			  return 60000;     // 1m
			// 9m
			case (interval <= 450000):
			  return 300000;    // 5m
			// 20m
			case (interval <= 1200000):
			  return 600000;    // 10m
			// 45m
			case (interval <= 2700000):
			  return 1800000;   // 30m
			// 2h
			case (interval <= 7200000):
			  return 3600000;   // 1h
			// 6h
			case (interval <= 21600000):
			  return 10800000;  // 3h
			// 24h
			case (interval <= 86400000):
			  return 43200000;  // 12h
			// 48h
			case (interval <= 172800000):
			  return 86400000;  // 24h
			// 1w
			case (interval <= 604800000):
			  return 86400000;  // 24h
			// 3w
			case (interval <= 1814400000):
			  return 604800000; // 1w
			// 2y
			case (interval < 3628800000):
			  return 2592000000; // 30d
			  default:
			  return 31536000000; // 1y
			}
		};
	flx.secondsToHms = function(seconds){
	    var numyears = Math.floor(seconds / 31536000);
	    if(numyears){
	      return numyears + 'y';
	    }
	    var numdays = Math.floor((seconds % 31536000) / 86400);
	    if(numdays){
	      return numdays + 'd';
	    }
	    var numhours = Math.floor(((seconds % 31536000) % 86400) / 3600);
	    if(numhours){
	      return numhours + 'h';
	    }
	    var numminutes = Math.floor((((seconds % 31536000) % 86400) % 3600) / 60);
	    if(numminutes){
	      return numminutes + 'm';
	    }
	    var numseconds = (((seconds % 31536000) % 86400) % 3600) % 60;
	    if(numseconds){
	      return numseconds + 's';
	    }
	    return '1s'; //'just now' //or other string you like;
	  };
	flx.colors=[
      "#7EB26D","#EAB839","#6ED0E0","#EF843C","#E24D42","#1F78C1","#BA43A9","#705DA0", //1
      "#508642","#CCA300","#447EBC","#C15C17","#890F02","#0A437C","#6D1F62","#584477", //2
      "#B7DBAB","#F4D598","#70DBED","#F9BA8F","#F29191","#82B5D8","#E5A8E2","#AEA2E0", //3
      "#629E51","#E5AC0E","#64B0C8","#E0752D","#BF1B00","#0A50A1","#962D82","#614D93", //4
      "#9AC48A","#F2C96D","#65C5DB","#F9934E","#EA6460","#5195CE","#D683CE","#806EB7", //5
      "#3F6833","#967302","#2F575E","#99440A","#58140C","#052B51","#511749","#3F2B5B", //6
      "#E0F9D7","#FCEACA","#CFFAFF","#F9E2D2","#FCE2DE","#BADFF4","#F9D9F9","#DEDAF7"  //7
  	];
  	flx.lastTimes=[
/*	  { from: 'now/d',    to: 'now/d',    display: 'Today',                 section: 0 },
	  { from: 'now/w',    to: 'now/w',    display: 'This week',             section: 0 },
	  { from: 'now/M',    to: 'now/M',    display: 'This month',            section: 0 },
	  { from: 'now/y',    to: 'now/y',    display: 'This year',             section: 0 },
	  { from: 'now/d',    to: 'now',      display: 'The day so far',        section: 0 },
	  { from: 'now/w',    to: 'now',      display: 'Week to date',          section: 0 },
	  { from: 'now/M',    to: 'now',      display: 'Month to date',         section: 0 },
	  { from: 'now/y',    to: 'now',      display: 'Year to date',          section: 0 },

	  { from: 'now-1d/d', to: 'now-1d/d', display: 'Yesterday',             section: 1 },
	  { from: 'now-2d/d', to: 'now-2d/d', display: 'Day before yesterday',  section: 1 },
	  { from: 'now-7d/d', to: 'now-7d/d', display: 'This day last week',    section: 1 },
	  { from: 'now-1w/w', to: 'now-1w/w', display: 'Previous week',         section: 1 },
	  { from: 'now-1M/M', to: 'now-1M/M', display: 'Previous month',        section: 1 },
	  { from: 'now-1y/y', to: 'now-1y/y', display: 'Previous year',         section: 1 },
*/
	  { from: 'now-15m',  to: 'now',      display: 'Last 15 minutes',       section: 2 },
	  { from: 'now-30m',  to: 'now',      display: 'Last 30 minutes',       section: 2 },
	  { from: 'now-1h',   to: 'now',      display: 'Last 1 hour',           section: 2 },
	  { from: 'now-4h',   to: 'now',      display: 'Last 4 hours',          section: 2 },
	  { from: 'now-12h',  to: 'now',      display: 'Last 12 hours',         section: 2 },
	  { from: 'now-24h',  to: 'now',      display: 'Last 24 hours',         section: 2 },
	  { from: 'now-7d',   to: 'now',      display: 'Last 7 days',           section: 2 },

	  { from: 'now-30d',  to: 'now',      display: 'Last 30 days',          section: 3 },
	  { from: 'now-60d',  to: 'now',      display: 'Last 60 days',          section: 3 },
	  { from: 'now-90d',  to: 'now',      display: 'Last 90 days',          section: 3 },
	  { from: 'now-6M',   to: 'now',      display: 'Last 6 months',         section: 3 },
	  { from: 'now-1y',   to: 'now',      display: 'Last 1 year',           section: 3 },
	  { from: 'now-2y',   to: 'now',      display: 'Last 2 years',          section: 3 },
	  { from: 'now-5y',   to: 'now',      display: 'Last 5 years',          section: 3 },
	];

	flx.refreshIntervals = [
	  { value : 0, display: 'Off', section: 0},
	  { value : 5000, display: '5 seconds', section: 1},
	  { value : 15000, display: '15 seconds', section: 1},
	  { value : 30000, display: '30 seconds', section: 1},
	  { value : 45000, display: '45 seconds', section: 1},

	  { value : 60000, display: '1 minute', section: 2},
	  { value : 300000, display: '5 minutes', section: 2},
	  { value : 900000, display: '15 minutes', section: 2},
	  { value : 1800000, display: '30 minutes', section: 2},

	  { value : 3600000, display: '1 hour', section: 3},
	  { value : 7200000, display: '2 hour', section: 3},
	  { value : 43200000, display: '12 hour', section: 3},
	  { value : 86400000, display: '1 day', section: 3}
	];

	return flx;
}

FlxFactory();
//alert(moment().tz.guess());